 ; Ŀ
 ;   Chart - read a text file into a chart.                                
 ;   Copyright 1996, 2007, 2008 by Rocket Software Ltd.                    
 ;                                                                         
 ;   The file in question must be a comma separated file.  Leading         
 ;   and trailing spaces in text strings are ignored, fields consisting    
 ;   solely of spaces are assumed to be empty but strings can contain      
 ;   spaces.  Empty rows are drawn normally and empty columns are given    
 ;   a width of 4 drawing units.                                           
 ;                                                                         
 ;   If the first line of the data file begins with "Config," it is used   
 ;   to configure the output:                                              
 ;   The initial three (required) fields are text height, box height,      
 ;   and distance between the ends of the text and the vertical lines.     
 ;   These are separated by the commas.                                    
 ;   Any after these are column justification indicators - L represents    
 ;   left justification, C (or anything else) is assumed to be centred.    
 ;   Width override numbers are appended to each justification code        
 ;   without intervening commas.                                           
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Fittx - make text fit into a space if it is too wide.      
 ;   Takes three arguments - the text ename and width, the width of the    
 ;   space the text is to occupy (with clearance) the justification, and   
 ;   the the clearance at the ends of the text.                            
 ;   If the box width is less than 2.5 x the clearance, the clearance is   
 ;   reduced to 1/4 of the box width.                                      
 ; 
 (DEFUN FITTX (enam ewidth boxwid just clear / entt clear1 calfc)
  (setq entt (entget enam))
  (setq clear1 clear)
 ; Ŀ
 ;   Find the actual width of the text string.                             
 ; 
  (setq ewidth (twid entt))
 ; Ŀ
 ;   See if the clearance around the text is ok.                           
 ; 
  (if (<= boxwid (* 2.5 clear))
      (setq clear (/ boxwid 4.0)))
 ; Ŀ
 ;   And find the space available for the text.                            
 ; 
  (setq space (- boxwid (* 2 clear)))
 ; Ŀ
 ;   If the text was left justified and the clearance was less than 2      
 ;   (the distance of the insertion of Left justified text from the left   
 ;   side of the box) and the text has to be squashed then it will have    
 ;   to be moved so that the clearance will be the same on both sides.     
 ;   Hang on - if the text is too long at a clearance of 2, but the        
 ;   clearance is shortened making the text ok, then the text will be ok   
 ;   but will be shifted too far to the right for the new clearance.       
 ;   So: if the clearance is less than two and the text fits and it is     
 ;   left justified, see if the text would fit if the clearance was two.   
 ;   If not then move it.                                                  
 ;   This is a kludgy solution to an unlikely situation - only an idiot    
 ;   would force text into ridiculously narrow boxes.                      
 ;   Wait - suppose that... much later: who knows?                         
 ; 
  (cond ((and (= (strcase just) "L")
              (< clear clear1)
              (> ewidth space))
;         (command "change" enam "" "p" "c" "green" "")
         (command "move" enam "" "0,0" (list (- clear clear1) 0)))
        ((and (= (strcase just) "L")
              (< clear clear1)
              (< ewidth space)
              (> ewidth (- boxwid (* 2 clear1))))
;         (command "change" enam "" "p" "c" "cyan" "")
         (command "move" enam "" "0,0" (list (- clear clear1) 0))))
 ; Ŀ
 ;   See if the text is longer than the available space.                   
 ; 
  (if (> ewidth space)
      (progn
 ; Ŀ
 ;   Reacquire the entity data for ename since it may have been changed    
 ;   by the move commands.                                                 
 ; 
           (setq entt (entget enam))
 ; Ŀ
 ;   Find the text width scale factor.                                     
 ; 
           (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
           (setq scalfc (/ space ewidth))
           (setq widscl (* widscl scalfc))
           (entmod (subst (cons 41 widscl) prev41 entt))
           (entupd enam)))
 (princ))
 ; Ŀ
 ;   Fittx end.                                                            
 ; 

 ; Ŀ
 ;   Dbubl - split the configuration list into two lists, one of           
 ;   justifications and one of widths.  Takes one argument, a list of      
 ;   strings, and returns two lists, each element in the original having   
 ;   been split into a single character string and a number.               
 ;   An empty string returns "" for the character and nil for the number.  
 ; 
 (DEFUN DBUBL (smaple / num sub just wid jlust whist)
  (setq num 0)
  (while (setq sub (nth num smaple))
         (setq just (substr sub 1 1))
         (setq wid (read (substr sub 2)))
         (setq jlust (append jlust (list just)))
         (setq whist (append whist (list wid)))
         (setq num (1+ num)))
 (list jlust whist))
 ; Ŀ
 ;   Dbubl end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lefter - place text in a box.                              
 ;   Draws a line of left justified text centred vertically, starting      
 ;   Clear units from the left side of the box.                            
 ;   Takes six arguments: the upper left point, the box height and width,  
 ;   text height, string, and end clearance.                               
 ;   Returns nothing.                                                      
 ; 
 (DEFUN LEFTER (pa boxht boxwid txht string clear / pb)
  (setq pb (polar pa (* pi 1.5) (/ (+ txht boxht) 2.0)))
  (setq pb (polar pb 0 clear))
  (command "text" pb txht 0 string)
 (princ))
 ; Ŀ
 ;   Lefter end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Centr - like Lefter but draws Centred text.                
 ; 
 (DEFUN CENTR (pa boxht boxwid txht string / pb)
  (setq pb (polar pa (* pi 1.5) (/ (+ txht boxht) 2.0)))
  (setq pb (polar pb 0 (/ boxwid 2.0)))
  (command "text" "c" pb txht 0 string)
 (princ))
 ; Ŀ
 ;   Centr end.                                                            
 ; 

 ; Ŀ
 ;   Twid - find the width of a hypothetical text string.                  
 ;   Takes one argument, the text ename, returns a length.                 
 ; 
 (DEFUN TWID (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Twid end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string at a given character, make    
 ;   into a list of substrings.                                            
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (and (/= linn "")
                     (= (substr linn (setq len (strlen linn))) " "))
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= name1 "")
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Chart.                                                                
 ; 
 (DEFUN C:CHART (/ *error* esav osmo filnam fn dets sepchr txht boxht clear
                   lin strngs num sub strwid subnum lenlst wid maxsub pa overht
                              pb pc pd dist strnum tmplst string just boxwid)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "osmode" osmo)
  (setvar "blipmode" blip)
  (command ".undo" "end")
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   Get a filename.  If this doesn't work, try a command line prompt.     
 ; 
  (setq filnam (getfiled "Data File" "data.fil" "" 0))
  (if (= filnam 1)
      (progn
           (setq filnam (Getstring "Data file name <Data.fil>: "))
           (if (= filnam "") (setq filnam "Data.fil"))))
 ; Ŀ
 ;   Open the file.                                                        
 ; 
  (setq fn (open filnam "r"))
 ; Ŀ
 ;   Read the remainder of the file into a list of text lists.             
 ; 
  (while (and (setq lin (read-line fn))
              (setq lin (splat "," lin)))
 ; Ŀ
 ;   Cond 1: if the line was empty, ignore it.                             
 ; 
         (cond ((equal lin (list "")))
 ; Ŀ
 ;   Cond 2: if the line was the first line and started with Config then   
 ;   it was a configuration line, so use it.                               
 ; 
               ((and (equal (strcase (car lin) t) "config")
                     (null strngs))
                (setq dets (cdr lin))
                (setq txht (read (car dets)))
                (setq boxht (read (cadr dets)))
                (setq clear (read (caddr dets)))
                (setq dets (cdddr dets)))
 ; Ŀ
 ;   Cond 3: the line was a data line, so process it and add it to strngs. 
 ; 
               (t
                 (if (null txht) (setq txht 2.5))
                 (setq strngs (append strngs (list lin)))
                 (setq num 0)
                 (while (setq sub (nth num lin))
                        (if (/= sub "")
                            (setq strwid (twid (list (cons 1 sub)
                                                     (cons 40 txht))))
                            (setq strwid 0))
                        (if (and lenlst (setq subnum (assoc num lenlst)))
                            (setq lenlst (subst (append subnum (list strwid))
                                                               subnum lenlst))
                        (setq lenlst (append lenlst
                                                 (list (list num strwid)))))
                        (grtext -2 (itoa (setq num (1+ num))))))))
  (close fn)
 ; Ŀ
 ;   If there was no Config line, make some defaults.                      
 ; 
  (if (null boxht)
      (progn
           (setq boxht 5)
           (setq clear 5)))
  (if (null dets)
      (setq dets (list "")))  ; if there are no just. codes
 ; Ŀ
 ;   Call Dbubl to convert dets into a list of formatting codes and one    
 ;   of box width override numbers.                                        
 ; 
  (if (null dets)
      (setq dets (list "")))  ; if there are no just. codes
  (setq dets (dbubl dets))
  (setq setwid (cadr dets))
  (setq dets (car dets))
 ; Ŀ
 ;   Find the width of each text box (converts Lenlst to a list of         
 ;   maximum widths), and Wid: the overall width.                          
 ; 
  (setq wid 0)
  (setq num 0)
  (while (setq sub (nth num lenlst))
         (setq ovrrid (nth num setwid))
 ; Ŀ
 ;   If there was an override width in the configuration list, use it for  
 ;   the box width, otherwise use the maximum text string width.           
 ; 
         (if ovrrid
             (setq maxsub ovrrid)
             (progn
                  (setq maxsub (eval (append (list max) (cdr sub))))
                  (if (= maxsub 0)
                      (setq maxsub 0)
                      (setq maxsub (fix (+ (* 2 clear) 0.999 maxsub))))))
         (setq wid (+ wid maxsub))
         (setq lenlst (subst maxsub sub lenlst))
         (grtext -2 (itoa (setq num (1+ num)))))
 ; Ŀ
 ;   If any box has a width of 0, set it to some arbitrary figure so that  
 ;   it will be apparent to the user that there is an empty column.        
 ; 
  (setq num 0)
  (while (setq sub (nth num lenlst))
         (grtext -2 (itoa (setq num (1+ num))))
         (if (= sub 0)
             (progn
                  (setq tmplst (append tmplst (list (* clear 2))))
                  (setq wid (+ wid (* clear 2))))
             (setq tmplst (append tmplst (list sub)))))
  (setq lenlst tmplst)
 ; Ŀ
 ;   Get the start point, draw the box outline.                            
 ; 
  (setq num (length strngs))
  (setq pa (getpoint "Start point: "))
  (setq overht (* num boxht))
  (setq pb (polar pa 0 wid))
  (setq pc (polar pb (* pi 1.5) overht))
  (setq pd (polar pc pi wid))
  (command "Pline" pa pb pc pd "c")
 ; Ŀ
 ;   Draw the horizontal lines.                                            
 ; 
  (setq pb pa)
  (repeat (1- num)
         (setq pb (polar pb (* pi 1.5) boxht))
         (setq pc (polar pb 0 wid))
         (command "line" pb pc ""))
 ; Ŀ
 ;   Draw the vertical lines.                                              
 ; 
  (setq num 0)
  (setq pb pa)
  (setq tmplst (reverse (cdr (reverse lenlst))))
  (while (setq dist (nth num tmplst))
         (setq num (1+ num))
         (setq pb (polar pb 0 dist))
         (setq pc (polar pb (* pi 1.5) overht))
         (command "line" pb pc ""))
 ; Ŀ
 ;   Now draw the text.                                                    
 ; 
  (setq num 0)
  (setq pb pa)
  (while (setq lin (nth num strngs))
         (setq num (1+ num))
         (setq strnum 0)
         (setq pb pa)
         (while (setq string (nth strnum lin))
                (if dets
                    (setq just (nth strnum dets))
                    (setq just ()))
                (if just (setq just (strcase just)))
                (setq ovrrid (nth strnum setwid))
                (setq boxwid (nth strnum lenlst))
                (setq strnum (1+ strnum))
                (setq elast (entlast))
                (if (= just "L")
                    (lefter pb boxht boxwid txht string clear)
                    (centr pb boxht boxwid txht string))
 ; Ŀ
 ;   If an override was set on the box width and a new entity was created  
 ;   (i.e. the string contained some characters) check the text to make    
 ;   sure it will fit, and squash it otherwise.                            
 ; 
                (if (and ovrrid (not (equal (setq enam (entlast)) elast)))
                    (fittx enam ewidth boxwid just clear))
 ; Ŀ
 ;   Reposition pb horizontally, return to start of inner loop.            
 ; 
                (setq pb (polar pb 0 boxwid)))
 ; Ŀ
 ;   Reposition pa vertically, return to start of outer loop.              
 ; 
         (setq pa (polar pa (* pi 1.5) boxht)))
 ; Ŀ
 ;   Restore sysvars, end.                                                 
 ; 
  (*error* nil)
 (princ))